package com.elitescloud.cloudt.system.service;

import org.springframework.http.HttpEntity;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/12
 */
public interface OpenApiQueryService {

    /**
     * 下载OpenApi
     *
     * @param openApiId openApiId
     * @return 流
     */
    HttpEntity<StreamingResponseBody> downloadOpenApi(@NotNull Long openApiId);

    /**
     * rpc调用下载OpenApi
     *
     * @param appCode 应用编码
     * @return 流
     */
    HttpEntity<StreamingResponseBody> downloadOpenApiByRpc(@NotBlank String appCode);
}
