package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.common.LoggingProperty;
import com.elitescloud.cloudt.system.common.TrackDoc;
import com.elitescloud.cloudt.system.model.entity.TrackDocDeleteParamVO;
import com.elitescloud.cloudt.system.model.vo.AuditLogVO;
import com.elitescloud.cloudt.system.model.vo.AuditQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.TrackDocQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.TrackDocRespVO;
//import com.elitesland.cbpl.unicom.adapter.SpecifyAdapter;
//import com.elitesland.cbpl.unicom.annotation.Unicom;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:25
 * @Description:
 */
//@Unicom(adapter = SpecifyAdapter.class)
public interface PipelineService {

    /**
     * 消费(or持久化)方式
     *
     * @param property 配置
     * @param trackDoc 日志内容
     * @return 消费是否成功
     */
    boolean consume(LoggingProperty property, TrackDoc trackDoc);

    /**
     * 通用 - 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query);

    /**
     * 通用 - 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query);

    /**
     * 通用 - 按条件删除日志
     *
     * @param paramVO 删除参数
     * @return 成功删除的日志条数
     */
    long trackDocDelete(TrackDocDeleteParamVO paramVO);


    // ======================== 定制接口 ======================== //

    /**
     * 审计日志 - 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query);
}
