package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RolePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.GroupRoleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleCloneSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleSaveVO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
public interface RoleMngService {

    /**
     * 保存角色
     *
     * @param saveVO 角色信息
     * @return 角色ID
     */
    ApiResult<Long> save(RoleSaveVO saveVO, BelongType.Belonger belonger);

    /**
     * 复制角色
     *
     * @param cloneSaveVO 角色信息
     * @return 角色ID
     */
    ApiResult<Long> saveClone(RoleCloneSaveVO cloneSaveVO);

    /**
     * 更新启用状态
     *
     * @param id 角色ID
     * @return 角色ID
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 更新名称
     *
     * @param id   角色ID
     * @param name 角色名称
     * @return 角色ID
     */
    ApiResult<Long> updateName(Long id, String name);

    /**
     * 删除角色
     *
     * @param id 角色ID
     * @return 角色ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 获取角色详情
     *
     * @param id 角色ID
     * @return 角色详情
     */
    ApiResult<RoleDetailRespVO> get(Long id);

    /**
     * 分页查询角色
     *
     * @param queryVO 查询参数
     * @return 角色信息
     */
    ApiResult<PagingVO<RolePageRespVO>> page(RolePageQueryVO queryVO, BelongType.Belonger belonger);

    /**
     * 获取角色组和角色
     *
     * @return 角色组和角色
     */
    ApiResult<List<GroupRoleRespVO>> listGroupRole(Boolean showDisabled, BelongType.Belonger belonger);
}
