package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.bo.ThirdPartAccountBO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 第三方账号管理.
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
public interface ThirdPartAccountQueryService {

    /**
     * 获取账号所属租户ID
     *
     * @param account 账号
     * @return 记录ID
     */
    ApiResult<Long> getTenantIdOfAccount(@NotBlank String account);

    /**
     * 获取账号配置
     *
     * @param accountType  账号类型
     * @param businessType 业务类型
     * @return 账号配置
     */
    ApiResult<ThirdPartAccountBO> get(@NotNull Long tenantId,
                                      @NotNull ThirdPartAccountType accountType,
                                      @NotNull SysThirdPartyAccountBusinessType businessType);
}
