package com.elitescloud.cloudt.system.service.devops;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceClassInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceThreadPoolsRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceThreadsRespVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
public interface ServiceInstanceService {

    /**
     * 获取服务实例信息
     *
     * @param serviceId 客户端ID
     * @param url       客户端URL
     * @return 服务实例信息
     */
    ApiResult<ServiceInstanceInfoRespVO> getServiceInstanceInfo(String serviceId, String url);

    /**
     * 获取属性
     *
     * @param serviceId    客户端ID
     * @param url          客户端URL
     * @param propertyName 属性名称
     * @return 属性值
     */
    ApiResult<Object> getProperty(String serviceId, String url, String propertyName);

    /**
     * 获取类的版本
     *
     * @param serviceId 客户端ID
     * @param url       客户端URL
     * @param className 类的全名称
     * @return 类的名称
     */
    ApiResult<ServiceInstanceClassInfoRespVO> getClass(String serviceId, String url, String className);

    /**
     * 获取线程信息
     *
     * @param serviceId 客户端ID
     * @param url 客户端URL
     * @return 线程信息
     */
    ApiResult<List<ServiceInstanceThreadsRespVO>> getThreads(String serviceId, String url);

    /**
     * 获取线程池信息
     *
     * @param serviceId 客户端ID
     * @param url 客户端URL
     * @return 线程信息
     */
    ApiResult<List<ServiceInstanceThreadPoolsRespVO>> getThreadPools(String serviceId, String url);
}
