package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 货币.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public class TaxRateInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "税率";
    }

    @Override
    public String tableName() {
        return "sys_tax_rate";
    }

    @Override
    public List<String> fields() {
        return List.of("tax_rate_no", "tax_rate_desc", "valid_from", "valid_to", "tax_rate_value", "enabled",
                "tax_rate_type", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("tax_rate_no", "税率编码");
        titles.put("tax_rate_value", "值");
        titles.put("tax_rate_desc", "描述");
        titles.put("valid_from", "起始时间");
        titles.put("valid_to", "截止时间");
        titles.put("tax_rate_type", "税率类型");
        titles.put("enabled", "状态");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        // 过滤启用的数据
        var enabled = getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled) {
            return null;
        }

        return data;
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var tax_rate_no = this.getStringValue(data, "tax_rate_no", null);
        Assert.notBlank(tax_rate_no, "税率编码为空");

        this.normalizeBooleanValue(data, "enabled");

        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var id = currentData.stream()
                .filter(t -> tax_rate_no.equals(t.get("tax_rate_no")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", id);
        return id == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
