package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.model.vo.BotMessage;
import com.elitescloud.cloudt.system.model.vo.BotRequest;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.service.InfinityLogListener;
import com.elitescloud.cloudt.system.util.BotSender;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:16
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BotService implements InfinityLogListener {
    @Override
    public boolean createLog(InfinityLogVO logVO) throws Exception {
        // 请求失败 or 响应失败 ====> 发送告警消息
        if (!logVO.getRequestSuccess() || !logVO.getResponseSuccess()) {
            BotRequest request = new BotRequest();
            // 详细日志对象
            request.setExtObj(logVO);
            // 报错内容
            BotMessage message = new BotMessage();
            message.setBizKey(StrUtil.blankToDefault(logVO.getBusinessKey(), "N/A"));
            message.setMessages(List.of(logVO.getResponseFailMessage()));
            // 推送
            BotSender.push(() -> request, List.of(message));
        }
        return true;
    }
}
