package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.service.TenantClientSpi;
import com.elitescloud.cloudt.system.util.IamUserUtil;
import com.elitescloud.cloudt.system.util.TenantUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.function.Supplier;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:11
 * @Description:
 */
public class CloudtTenantClientService implements TenantClientSpi {
    private static final Logger log = LoggerFactory.getLogger(CloudtTenantClientService.class);
    @Resource
    private TenantWrapper tenantWrapper;

    public void byTenants(Runnable executor) {
        this.tenantWrapper.byAllTenant(executor);
    }

    public void byTenantDirectly(Runnable executor, String tenantCode) {
        this.tenantWrapper.byTenantDirectly(executor, tenantCode);
    }

    public <E> E byTenantDirectly(Supplier<E> executor, String tenantCode) {
        return this.tenantWrapper.byTenantDirectly(executor, tenantCode);
    }

    public void setCurrentTenant(Long tenantId) {
        TenantUtil.setCurrentTenant(tenantId);
    }

    public void setCurrentTenant(String tenantCode) {
        TenantUtil.setCurrentTenant(tenantCode);
    }

    public void resetCurrentTenant() {
        TenantUtil.resetCurrentTenant();
    }

    public String currentTenantCode() {
        return IamUserUtil.currentTenantCode();
    }

    public CloudtTenantClientService() {
    }
}
