package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorListRespVO;
import com.elitescloud.cloudt.system.service.DataSelectorQueryService;
import com.elitescloud.cloudt.system.service.repo.DataSelectorGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataSelectorRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/17
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
public class DataSelectorQueryServiceImpl implements DataSelectorQueryService {

    @Autowired
    private DataSelectorRepoProc repoProc;
    @Autowired
    private DataSelectorGroupRepoProc groupRepoProc;

    @Override
    public ApiResult<List<CommonDataSelectorListRespVO>> listTree(Boolean tree) {
        var groupList = this.listTreeOfGroup();
        if (groupList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }

        List<CommonDataSelectorListRespVO> respVoList = new ArrayList<>(128);
        respVoList.addAll(groupList);
        respVoList.addAll(listTreeOfDataSelector(groupList));

        TreeDataUtil<CommonDataSelectorListRespVO> treeDataUtil = new TreeDataUtil<>(respVoList, CommonDataSelectorListRespVO::getId,
                CommonDataSelectorListRespVO::getParentId, CommonDataSelectorListRespVO::setChildren, Comparator.comparingInt(CommonDataSelectorListRespVO::getSortNo));
        var resultList = ((List<CommonDataSelectorListRespVO>) treeDataUtil.getRoots()).stream()
                .filter(t -> Boolean.FALSE.equals(t.getDataSelector()))
                .collect(Collectors.toList());
        if (tree == null || tree) {
            return ApiResult.ok(resultList);
        }

        resultList = CollectionUtil.expandTree(resultList, CommonDataSelectorListRespVO::getChildren);
        return ApiResult.ok(resultList);
    }

    private List<CommonDataSelectorListRespVO> listTreeOfDataSelector(List<CommonDataSelectorListRespVO> groups) {
        var groupMap = groups.stream().collect(Collectors.toMap(CommonDataSelectorListRespVO::getCode, CommonDataSelectorListRespVO::getId, (t1, t2) -> t1));

        AtomicInteger sortNO = new AtomicInteger(0);
        return repoProc.queryList().stream()
                .map(t -> {
                    CommonDataSelectorListRespVO respVO = new CommonDataSelectorListRespVO();
                    respVO.setDataSelector(true);
                    respVO.setId(t.getId());
                    respVO.setCode(t.getSelectorCode());
                    respVO.setName(t.getSelectorName());
                    respVO.setSortNo(sortNO.getAndIncrement());
                    respVO.setParentId(groupMap.get(t.getGroupCode()));
                    respVO.setParentCode(t.getGroupCode());

                    return respVO;
                }).collect(Collectors.toList());
    }

    private List<CommonDataSelectorListRespVO> listTreeOfGroup() {
        AtomicInteger sortNO = new AtomicInteger(0);
        return groupRepoProc.listGroup()
                .stream()
                .map(t -> {
                    CommonDataSelectorListRespVO respVO = new CommonDataSelectorListRespVO();
                    respVO.setDataSelector(false);
                    respVO.setId(t.getId());
                    respVO.setCode(t.getCode());
                    respVO.setName(t.getName());
                    respVO.setSortNo(sortNO.getAndIncrement());

                    return respVO;
                }).collect(Collectors.toList());
    }
}
