package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.model.vo.resp.extend.HttpParam;
import com.elitescloud.cloudt.system.service.SecurityAuthService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * @Auther: Mark
 * @Date: 2024/12/24 19:19
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
//@UnicomTag("NO_AUTH")
public class NoAuthSecurityService implements SecurityAuthService {
    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        log.info("[BPMN][INFINITY] Auth Method: " + AuthMethod.AUTH_METHOD_NO_AUTH.getDesc());
        return true;
    }

    @Override
    public String getAuthType() {
        return AuthMethod.AUTH_METHOD_NO_AUTH.getCode();
    }
}
