package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.service.ThirdPartAccountQueryService;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.bo.ThirdPartAccountBO;
import com.elitescloud.cloudt.system.service.repo.ThirdPartyAccountRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
public class ThirdPartAccountQueryServiceImpl extends BaseServiceImpl implements ThirdPartAccountQueryService {

    @Autowired
    private ThirdPartyAccountRepoProc repoProc;

    @Override
    public ApiResult<Long> getTenantIdOfAccount(String account) {
        Assert.hasText(account, "账号为空");

        var tenantId = repoProc.getTenantIdByAccount(account);
        return ApiResult.ok(tenantId);
    }

    @Override
    public ApiResult<ThirdPartAccountBO> get(@NotNull Long tenantId, ThirdPartAccountType accountType, SysThirdPartyAccountBusinessType businessType) {
        Assert.notNull(tenantId, "租户ID为空");
        Assert.notNull(accountType, "账号类型为空");
        Assert.notNull(businessType, "业务类型为空");

       var config = repoProc.getAccountConfig(accountType, businessType.getValue(), tenantId);

        return ApiResult.ok(config);
    }
}
