package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysAlertConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysAlertConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysAlertDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Repository
public class AlertConfigRepoProc extends BaseRepoProc<SysAlertConfigDO> {
    private static final QSysAlertConfigDO QDO = QSysAlertConfigDO.sysAlertConfigDO;

    public AlertConfigRepoProc() {
        super(QDO);
    }

    /**
     * 判断是否存在
     *
     * @param businessType
     * @param alertType
     * @return
     */
    public boolean existsByBusinessType(@NotBlank String businessType, @NotBlank String alertType) {
        return super.jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.businessType.eq(businessType).and(QDO.alertType.eq(alertType)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 根据业务类型获取
     *
     * @param businessType
     * @return
     */
    public SysAlertConfigDO getByBusinessType(@NotBlank String businessType, @NotBlank String alertType) {
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.businessType.eq(businessType).and(QDO.alertType.eq(alertType)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取配置列表
     *
     * @param businessType
     * @return
     */
    public List<SysAlertConfigDO> getByBusinessType(@NotBlank String businessType) {
        return super.getList(QDO.businessType.eq(businessType));
    }
}
