package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationPagedRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataRelationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Repository
public class DataRelationRepoProc extends BaseRepoProc<SysDataRelationDO> {
    private static final QSysDataRelationDO QDO = QSysDataRelationDO.sysDataRelationDO;
    private static final QSysBusinessObjectDO QDO_BO = QSysBusinessObjectDO.sysBusinessObjectDO;

    public DataRelationRepoProc() {
        super(QDO);
    }

    public void updateEnabled(long id, boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    public boolean existsCode(@NotBlank String code, Long id) {
        return super.exists(QDO.code, code, id);
    }

    public boolean exists(@NotBlank String boCode, @NotBlank String refBoCode, Long id) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.boCode, boCode)
                .andEq(QDO.refBoCode, refBoCode)
                .andNe(QDO.id, id)
                .build();
        return super.exists(predicate);
    }

    public String getCode(long id) {
        return super.getValue(QDO.code, id);
    }

    public PagingVO<DataRelationPagedRespVO> pageMng(DataRelationPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.code, queryVO.getCode())
                .andLike(QDO.name, queryVO.getName())
                .andEq(QDO.boCode, queryVO.getBoCode())
                .andIn(StringUtils.hasText(queryVO.getBoName()), QDO.boCode, () -> JPAExpressions.select(QDO_BO.code).from(QDO_BO).where(QDO_BO.customName.like("%" + queryVO.getBoName() + "%")))
                .andIn(StringUtils.hasText(queryVO.getRefBoName()), QDO.refBoCode, () -> JPAExpressions.select(QDO_BO.code).from(QDO_BO).where(QDO_BO.customName.like("%" + queryVO.getRefBoName() + "%")))
                .andEq(QDO.refBoCode, queryVO.getRefBoCode())
                .andEq(QDO.enabled, queryVO.getEnabled())
                .andLike(new StringExpression[]{QDO.code, QDO.name}, queryVO.getKeyword())
                .build();
        var qBean = Projections.bean(DataRelationPagedRespVO.class, QDO.id, QDO.code, QDO.name, QDO.boCode, QDO.refBoCode,
                QDO.enabled, QDO.createTime, QDO.modifyTime, QDO.dataSelectorCode);

        var jpaQuery = super.jpaQueryFactory.select(qBean)
                .from(QDO)
                .where(predicate);
        return super.queryByPage(jpaQuery, queryVO.getPageRequest());
    }

    public SysDataRelationDO getByCode(@NotBlank String code) {
        return super.getOneByValue(QDO.code, code);
    }
}
