package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.bo.DataSelectorSimpleBO;
import com.elitescloud.cloudt.system.model.vo.query.sys.DataSelectorPagedQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorPagedRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataSelectorDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataSelectorGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataSelectorDO;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Repository
public class DataSelectorRepoProc extends BaseRepoProc<SysDataSelectorDO> {
    private static final QSysDataSelectorDO QDO = QSysDataSelectorDO.sysDataSelectorDO;
    private static final QSysDataSelectorGroupDO QDO_GROUP = QSysDataSelectorGroupDO.sysDataSelectorGroupDO;

    public DataSelectorRepoProc() {
        super(QDO);
    }

    public void updateEnabled(long id, boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    public boolean existsCode(String code) {
        return super.exists(QDO.selectorCode, code);
    }

    public boolean existsGroup(long groupId) {
        var predicate = QDO.groupCode.eq(
                JPAExpressions.select(QDO_GROUP.groupCode).from(QDO_GROUP).where(QDO_GROUP.id.eq(groupId))
        );
        return super.exists(predicate);
    }

    public boolean existsGroup(String groupCode) {
        var predicate = QDO.groupCode.eq(groupCode);
        return super.exists(predicate);
    }

    public String getName(@NotBlank String code) {
        return super.getValueByValue(QDO.selectorName, QDO.selectorCode, code);
    }

    public Map<String, String> getNames(@NotEmpty Collection<String> codes) {
        return super.queryMap(QDO.selectorCode, QDO.selectorName);
    }

    public List<DataSelectorSimpleBO> listByCodes(Collection<String> codes) {
        return this.jpaQuerySimpleBO(QDO.selectorCode.in(codes));
    }

    public List<DataSelectorSimpleBO> queryList() {
        return this.jpaQuerySimpleBO(QDO.enabled.eq(true));
    }

    public SysDataSelectorDO getByCode(@NotBlank String code) {
        return super.getOneByValue(QDO.selectorCode, code);
    }

    public PagingVO<DataSelectorPagedRespVO> pageMng(DataSelectorPagedQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.selectorCode, queryVO.getSelectorCode())
                .andLike(QDO.selectorName, queryVO.getSelectorName())
                .andEq(QDO.groupCode, queryVO.getGroupCode())
                .andEq(QDO.enabled, queryVO.getEnabled())
                .andLike(new StringExpression[]{QDO.selectorCode, QDO.selectorName}, queryVO.getKeyword())
                .build();
        var qBean = Projections.bean(DataSelectorPagedRespVO.class, QDO.id, QDO.selectorCode, QDO.selectorName, QDO.enabled,
                QDO.component, QDO.componentCode, QDO.dataApi, QDO.dataApiMethod, QDO.createTime, QDO.modifyTime, QDO.groupCode,
                QDO_GROUP.groupName);
        var jpaQuery = super.jpaQueryFactory.select(qBean)
                .from(QDO)
                .leftJoin(QDO_GROUP).on(QDO_GROUP.groupCode.eq(QDO.groupCode))
                .where(predicate);
        return super.queryByPage(jpaQuery, queryVO.getPageRequest(), defaultOrder());
    }

    private List<DataSelectorSimpleBO> jpaQuerySimpleBO(Predicate predicate) {
        var pathGroupName = JPAExpressions.select(QDO_GROUP.groupName).from(QDO_GROUP).where(QDO_GROUP.groupCode.eq(QDO.groupCode));
        return super.jpaQueryFactory.select(QDO.id, QDO.groupCode, QDO.selectorCode, QDO.selectorName, QDO.component, QDO.componentCode,
                        QDO.dataApi, QDO.dataApiMethod, QDO.dataStyle,
                        pathGroupName)
                .from(QDO)
                .where(predicate)
                .orderBy(defaultOrder())
                .fetch()
                .stream()
                .map(t -> {
                    DataSelectorSimpleBO simpleBO = new DataSelectorSimpleBO();
                    simpleBO.setGroupCode(t.get(QDO.groupCode));
                    simpleBO.setGroupName(t.get(pathGroupName));
                    simpleBO.setSelectorCode(t.get(QDO.selectorCode));
                    simpleBO.setSelectorName(t.get(QDO.selectorName));
                    simpleBO.setComponent(t.get(QDO.component));
                    simpleBO.setComponentCode(t.get(QDO.componentCode));
                    simpleBO.setDataApi(t.get(QDO.dataApi));
                    simpleBO.setDataApiMethod(t.get(QDO.dataApiMethod));
                    simpleBO.setDataStyle(t.get(QDO.dataStyle));

                    return simpleBO;
                }).collect(Collectors.toList());
    }

    private OrderSpecifier<LocalDateTime> defaultOrder() {
        return QDO.createTime.desc();
    }
}
