package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.model.entity.InfinityPlatformDO;
import com.elitescloud.cloudt.system.model.entity.QInfinityPlatformDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiPagingParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiPagingVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiRespVO;
import com.elitescloud.cloudt.system.util.SqlUtil;
import com.querydsl.core.types.*;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 13:58
 * @Description:
 */
@Component
@RequiredArgsConstructor
public class InfinityPlatformRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinityPlatformDO platformDO = QInfinityPlatformDO.infinityPlatformDO;

    private final QBean<ThirdApiPagingVO> platformPagingVO = Projections.bean(
            ThirdApiPagingVO.class,
            platformDO.id,
            platformDO.platformName,
            platformDO.platformCode,
            platformDO.serverUrl,
            platformDO.authMethod,
            platformDO.description,
            platformDO.remark,
            platformDO.createUserId,
            platformDO.creator,
            platformDO.createTime,
            platformDO.modifyUserId,
            platformDO.updater,
            platformDO.modifyTime
    );

    private Predicate pagingWhere(ThirdApiPagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(platformDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getPlatformCodeName())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getPlatformCodeName());
            predicates.add(platformDO.platformCode.eq(likeStr).or(platformDO.platformName.like(likeStr)));
        }
        if (StrUtil.isNotBlank(query.getServerUrl())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getServerUrl());
            predicates.add(platformDO.serverUrl.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long platformCountBy(ThirdApiPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(platformDO.id)
                .from(platformDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<InfinityPlatformDO> platformPageBy(ThirdApiPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(platformDO)
                .from(platformDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, platformDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private final QBean<ThirdApiRespVO> platformVO = Projections.bean(
            ThirdApiRespVO.class,
            platformDO.id,
            platformDO.platformName,
            platformDO.platformCode,
            platformDO.serverUrl,
            platformDO.authMethod,
            platformDO.remark
    );

    private Predicate where(ThirdApiQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(platformDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getPlatformCodeName())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getPlatformCodeName());
            predicates.add(platformDO.platformCode.eq(likeStr).or(platformDO.platformName.like(likeStr)));
        }
        if (StrUtil.isNotBlank(query.getServerUrl())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getServerUrl());
            predicates.add(platformDO.serverUrl.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinityPlatformDO> platformByParam(ThirdApiQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(platformDO)
                .from(platformDO);
        // 按名称正序
        jpaQuery.orderBy(new OrderSpecifier<>(Order.ASC, platformDO.platformName));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = jpaQueryFactory.delete(platformDO)
                .where(platformDO.id.in(ids));
        return delete.execute();
    }

    
    //判断编码是否已存在

    public boolean existsByCode(Long id, String platformCode) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(platformDO.platformCode.eq(platformCode));
        if (ObjectUtil.isNotNull(id)) {
            predicates.add(platformDO.id.ne(id));
        }
        var jpaQuery = jpaQueryFactory.select(platformDO.id)
                .from(platformDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return !jpaQuery.fetch().isEmpty();
    }
}
