package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysNoticeTxtDO;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeTxtDO;
import org.springframework.stereotype.Repository;

import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Repository
public class NoticeTxtRepoProc extends BaseRepoProc<SysNoticeTxtDO> {

    private static final QSysNoticeTxtDO QDO = QSysNoticeTxtDO.sysNoticeTxtDO;

    public NoticeTxtRepoProc() {
        super(QDO);
    }

    public void deleteByNoticeId(long noticeId) {
        super.deleteByValue(QDO.noticeId, noticeId);
    }

    public void deleteByNoticeId(Collection<Long> noticeIds) {
        super.deleteByValue(QDO.noticeId, noticeIds);
    }

    public String getTxt(long id) {
        return super.getValue(QDO.txt, id);
    }

    public String getTxtByNoticeId(long noticeId) {
        return super.getValueByValue(QDO.txt, QDO.noticeId, noticeId);
    }
}
