package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysOpenApiTagDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiTagDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/13
 */
@Repository
public class OpenApiTagRepoProc extends BaseRepoProc<SysOpenApiTagDO> {
    private static final QSysOpenApiTagDO QDO = QSysOpenApiTagDO.sysOpenApiTagDO;

    public OpenApiTagRepoProc() {
        super(QDO);
    }

    /**
     * 删除数据
     *
     * @param openApiId
     */
    @Transactional(rollbackFor = Exception.class)
    public void deleteByOpenApiId(long openApiId) {
        super.delete(QDO.openApiInfoId.eq(openApiId));
    }
}
