package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.system.model.entity.SysPositionOrgDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.Set;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-10 10:33
 */
public interface SysPositionOrgRepo extends JpaRepository<SysPositionOrgDO, Long>, QuerydslPredicateExecutor<SysPositionOrgDO> {
    @Transactional
    @Modifying
    @Query("delete from SysPositionOrgDO s where s.positionCode = ?1")
    int deleteByPositionCode(String positionCode);
    @Query("select s from SysPositionOrgDO s where s.positionCode = ?1")
    Set<SysPositionOrgDO> findByPositionCode(String positionCode);

}
