package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-05-13 16:15
 */
public interface SysPositionRepo extends JpaRepository<SysPositionDO, Long>, QuerydslPredicateExecutor<SysPositionDO> {
    @Query("select s from SysPositionDO s where s.positionCode = ?1")
    List<SysPositionDO> findByPositionCode(String positionCode);

    @Query("select s from SysPositionDO s where s.positionCode = ?1")
    SysPositionDO findOneByPositionCode(String positionCode);
}
