package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.system.model.entity.SysPositionRoleDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-10 10:33
 */
public interface SysPositionRoleRepo extends JpaRepository<SysPositionRoleDO, Long>, QuerydslPredicateExecutor<SysPositionRoleDO> {
    @Transactional
    @Modifying
    @Query("delete from SysPositionRoleDO s where s.positionCode = ?1")
    int deleteByPositionCode(String positionCode);
    @Query("select s from SysPositionRoleDO s where s.positionCode = ?1")
    List<SysPositionRoleDO> findByPositionCode(String positionCode);

}
