package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.service.InfinityTrackService;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:41
 * @Description:
 */
@Slf4j
@NoArgsConstructor
public class InfinityLogUtil {
    private static InfinityTrackService trackService;

    private static InfinityTrackService getInstance() {
        if (trackService == null) {
            trackService = SpringUtil.getBean(InfinityTrackService.class);
        }
        return trackService;
    }

    /**
     * 接口(被动)调用日志
     *
     * @param request      客户端请求
     * @param response     客户端响应
     * @param responseBody 接口返回结果
     */
    public static void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        getInstance().record(request, response, responseBody);
    }

    /**
     * 接口(主动)调用日志
     *
     * @param requestParam 接口请求参数
     * @since 0.1.12-SNAPSHOT
     */
    public static void record(InfinityLogVO requestParam) {
        getInstance().record(requestParam);
    }
}
