package com.elitescloud.cloudt.ucenter.api.dto;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "单据来源配置明细")
public class ReceiptSourceConfigDetailDTO implements Serializable{

    private static final long serialVersionUID = 110960819106960960L;

    @ApiModelProperty(value = "来源编号")
    private String sourceNo;

    @ApiModelProperty(value = "透出字段")
    private String fieldName;

    @ApiModelProperty(value = "字段定义")
    private String fieldDefinition;

    @ApiModelProperty(value = "来源名称")
    private String sourceName;

    @ApiModelProperty(value = "来源类型")
    @SysCode(sys = Application.NAME, mod = "TYPE_SOURCE")
    private String sourceType;
    private String sourceTypeName;

    @ApiModelProperty(value = "记录创建者ID")
    private Long createUserId;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;
}
