package com.elitescloud.cloudt.ucenter.api.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(description = "显示/隐藏入参")
public class WebsiteBarShowParam implements Serializable {

    private static final long serialVersionUID = 5771439104790143L;

    @ApiModelProperty(value = "网站栏目配置id集合", required = true)
    @NotEmpty(message = "id不能为空")
    private List<Long> ids;

    @ApiModelProperty(value = "是否显示", required = true)
    @NotNull(message = "显示/隐藏不能为空")
    private Boolean showFlag;

}
