package com.elitescloud.cloudt.ucenter.api.vo.resp;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(description = "文章分类出参")
@Data
public class ArticleManageRespVO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;

    @ApiModelProperty("文章分类id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("文章分类名称")
    private String categoryName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "父级ID")
    private Long pid;

    @ApiModelProperty(value = "路径")
    private String path;

    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    @ApiModelProperty(value = "科目级别")
    private Integer level;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @SysCode(sys =  Application.NAME, mod = "SHOW_FLAG")
    private String showFlag;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    private String showFlagName;

    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    @ApiModelProperty(value = "文章分类下级")
    private List<ArticleManageRespVO> child;
}
