package com.elitescloud.cloudt.ucenter.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
@ApiModel(description = "单据来源配置新增编辑入参")
public class ReceiptSourceConfigSaveVO implements Serializable {

    private static final long serialVersionUID = 4406789299601680378L;


    @ApiModelProperty(value = "单据来源配置id")
    private Long id;

    @ApiModelProperty(value = "来源编号")
    @NotBlank(message = "来源编号不能为空")
    private String sourceNo;

    @ApiModelProperty(value = "来源名称")
    private String sourceName;

    @ApiModelProperty(value = "来源类型")
    private String sourceType;

    @ApiModelProperty(value = "接口URL")
    private String connectUrl;

    @ApiModelProperty(value = "接口参数")
    private String paramValue;
}
