package com.elitescloud.cloudt.ucenter.config;

import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;


/**
 * 通用中心的swagger配置.
 */
@Configuration
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
public class UcenterSwaggerConfig extends BaseSwaggerConfig {

    public UcenterSwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        super(openApiExtensionResolver, serverProperties);
    }

    @Bean
    public Docket createUcenterRestApi() {
        return createDocket("UCenterAPI", "com.elitescloud.cloudt.ucenter.controller");
    }

}
