package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarSortParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.UpBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteBarSaveVO;
import com.elitescloud.cloudt.ucenter.service.WebsiteBarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * 网站栏目配置
 *
 * @author chaofeng.xia
 * @date 2023/5/26 16:12
 */
@RestController
@RequestMapping(value = "/website/bar", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "网站栏目配置", tags = {"网站栏目配置"})
@RequiredArgsConstructor
@Validated
public class WebsiteBarController {


    private final WebsiteBarService websiteBarService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "网站栏目分页查询")
    public ApiResult<PagingVO<WebsiteBarRespVO>> search(@RequestBody WebsiteBarPagingParam param) {
        return ApiResult.ok(websiteBarService.search(param));
    }

    @DeleteMapping(value = "/delete")
    @ApiOperation(value = "删除")
    public ApiResult<?> batchDeleteByIds(@RequestBody List<Long> ids) {
        return ApiResult.ok(websiteBarService.batchDeleteByIds(ids));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存编辑")
    public ApiResult<Long> save(@RequestBody @Valid WebsiteBarSaveVO saveVO) {
        return ApiResult.ok(websiteBarService.save(saveVO));
    }

    @PostMapping(value = "/show/update")
    @ApiOperation(value = "显示/隐藏编辑")
    public ApiResult<?> showUpdate(@RequestBody WebsiteBarShowParam param) {
        return ApiResult.ok(websiteBarService.showUpdate(param));
    }

    @PostMapping(value = "/sort/update")
    @ApiOperation(value = "排序编辑")
    public ApiResult<?> sortUpdate(@RequestBody WebsiteBarSortParam param) {
        return ApiResult.ok(websiteBarService.sortUpdate(param));
    }


    @GetMapping(value = "/query/{id}")
    @ApiOperation(value = "网站栏目详情查询")
    public ApiResult<WebsiteBarRespVO> queryDetail(@PathVariable Long id) {
        return ApiResult.ok(websiteBarService.queryDetail(id));
    }

    @GetMapping(value = "/query/up/{barType}")
    @ApiOperation(value = "获取上级栏目")
    public ApiResult<List<UpBarRespVO>> queryUpBar(@PathVariable String barType) {
        return ApiResult.ok(websiteBarService.queryUpBar(barType));
    }

}
