package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 文件信息
 */
@Entity
@Table(name = "sys_file_info")
@org.hibernate.annotations.Table(appliesTo = "sys_file_info", comment = "文件信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class FileInfoDO extends BaseModel {

    @Column(name = "url")
    private String url;

    @Column(name = "file_code")
    private String fileCode;

    @Column(name = "source_id")
    private Long sourceId;

    @Column(name = "source_type")
    private String sourceType;

    @Column(name = "file_name")
    private String fileName;

    @Column(name = "old_file_name")
    private String oldFileName;

    @Column(name = "file_size")
    private String fileSize;

    @Column(name = "file_info")
    private String fileInfo;

    @Column(name = "original_name")
    private String originalName;

    @Column(name = "suffix")
    private String suffix;

    @Column(name = "mime_type")
    private String mimeType;

    @ApiModelProperty(value = "常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见")
    @Column(name = "file_type")
    private String fileType;

    @ApiModelProperty(value = "上传时间")
    @Column(name = "upload_time")
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "文件路径")
    @Column(name = "file_path")
    private String filePath;

    @ApiModelProperty(value = "宽度，图片时有值")
    @Column(name = "width")
    private Integer width;

    @ApiModelProperty(value = "高度，图片时有值")
    @Column(name = "height")
    private Integer height;

    @ApiModelProperty(value = "文件预览url")
    @Column(name = "urlPreview")
    private String urlPreview;

    @ApiModelProperty(value = "文件下载uri")
    @Column(name = "uri_down_load")
    private String uriDownload;

    @ApiModelProperty(value = "文件删除url")
    @Column(name = "url_delete")
    private String urlDelete;

}