package com.elitescloud.cloudt.ucenter.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_message_receiver", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_message_receiver", comment = "消息接收者信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MessageReceiverDO extends BaseModel implements Serializable {


    @Column(name = "message_id")
    private Long messageId;

    @Column(name = "emp_id")
    private Long empId;

    @Column(name = "emp_no")
    private String empNo;

    @Column(name = "emp_name")
    private String empName;

    @Column(name = "mobile")
    private String mobile;

    @Column(name = "dept_name")
    private String deptName;

    @Column(name = "read_status")
    private String readStatus;

    @Column(name = "read_time")
    private LocalDateTime readTime;
}
