package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_receipt_source_config_detail")
@org.hibernate.annotations.Table(appliesTo = "sys_receipt_source_config_detail", comment = "单据来源配置明细")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ReceiptSourceConfigDetailDO extends BaseModel implements Serializable {

    @Column(name = "mas_id")
    private Long masId;

    @Column(name = "source_no")
    private String sourceNo;

    @Column(name = "field_name")
    private String fieldName;

    @Column(name = "field_definition")
    private String fieldDefinition;
}