package com.elitescloud.cloudt.ucenter.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteAppearanceVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteAppearanceSaveVO;
import com.elitescloud.cloudt.ucenter.common.constant.ConstantsUcenter;
import com.elitescloud.cloudt.ucenter.convert.WebsiteAppearanceConvert;
import com.elitescloud.cloudt.ucenter.entity.WebsiteAppearanceDO;
import com.elitescloud.cloudt.ucenter.repo.WebsiteAppearanceRepo;
import com.elitescloud.cloudt.ucenter.repo.WebsiteAppearanceRepoProc;
import com.elitescloud.cloudt.ucenter.service.WebsiteAppearanceService;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * 网站外观配置信息
 *
 * @author chaofeng.xia
 * @date 2023/5/26 16:35
 */

@Service
@RequiredArgsConstructor
public class WebsiteAppearanceServiceImpl implements WebsiteAppearanceService {

    private final WebsiteAppearanceRepo appearanceRepo;

    private final WebsiteAppearanceRepoProc appearanceRepoProc;


    @Override
    @SysCodeProc
    public WebsiteAppearanceVO findByType(String type) {
        if (StringUtils.isEmpty(type)) {
            throw new BusinessException("网站类型不能为空");
        }
        return WebsiteAppearanceConvert.INSTANCE.do2Vo(appearanceRepo.findByType(type));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(WebsiteAppearanceSaveVO appearanceSaveVO) {
        // 校验表单

        if (StringUtils.isEmpty(appearanceSaveVO.getType())) {
            throw new BusinessException("网站类型不能为空");
        }
        if (appearanceSaveVO.getType().endsWith(ConstantsUcenter.WEBSITE_TYPE_APP)) {
            if (StringUtils.isEmpty(appearanceSaveVO.getBrowserLogoId())) {
                throw new BusinessException("登陆页icon不能为空");
            }
        } else {
            if (StringUtils.isEmpty(appearanceSaveVO.getBrowserLogoId())) {
                throw new BusinessException("浏览器logo不能为空");
            }
            if (StringUtils.isEmpty(appearanceSaveVO.getWebpageLogoId())) {
                throw new BusinessException("网页logo不能为空");
            }
            if (ObjectUtils.isEmpty(appearanceSaveVO.getMenuUnfoldFlag())) {
                throw new BusinessException("菜单展开状态不能为空");
            }
            if (ObjectUtils.isEmpty(appearanceSaveVO.getMenuWidth())) {
                throw new BusinessException("菜单区域宽度不能为空");
            }
        }

        // 判断是新增还是更新
        if (ObjectUtils.isEmpty(appearanceSaveVO.getId())) {
            if (appearanceRepo.existsByType(appearanceSaveVO.getType())) {
                throw new BusinessException("请勿重复添加该类型网站配置，请检查！");
            }
        } else {
            if (!appearanceRepo.existsById(appearanceSaveVO.getId())) {
                throw new BusinessException("id不存在，请检查！");
            }
        }

        WebsiteAppearanceDO appearanceDO = appearanceRepo.save(WebsiteAppearanceConvert.INSTANCE.saveVo2Do(appearanceSaveVO));
        return appearanceDO.getId();
    }

    @Override
    @SysCodeProc
    public WebsiteAppearanceVO findById(Long id) {
        WebsiteAppearanceDO appearanceDO = appearanceRepo.findById(id).orElseThrow(new BusinessException("id不存在，请检查！"));
        return WebsiteAppearanceConvert.INSTANCE.do2Vo(appearanceDO);
    }
}
