-- yst_dev2_ucenter.ad_info definition
-- 初始化通用域表。 迁移通用域的代码，迁移原yst-ucenter-test-v3.2.0版本
CREATE TABLE IF NOT EXISTS `sys_ad_info`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ad_code`            varchar(64)  DEFAULT NULL COMMENT '广告编码',
    `ad_title`           varchar(256) DEFAULT NULL COMMENT '广告标题',
    `ad_space_id`        bigint(20) DEFAULT NULL COMMENT '广告位id',
    `ad_space_code`      varchar(256) DEFAULT NULL COMMENT '广告位编码',
    `ad_space_name`      varchar(256) DEFAULT NULL COMMENT '广告位名称',
    `ad_link_type`       varchar(16)  DEFAULT NULL COMMENT '链接类型 internal-内部链接  external-外部链接  custom-自定义',
    `show_flag`          varchar(16)  DEFAULT NULL COMMENT '是否显示 HIDE-隐藏 DISPLAY-显示',
    `sort_no`            int(11) DEFAULT NULL COMMENT '广告排序',
    `show_begin_time`    datetime     DEFAULT NULL COMMENT '广告开始时间',
    `show_end_time`      datetime     DEFAULT NULL COMMENT '广告结束时间',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型(文章)',
    `link_address_id`    bigint(20) DEFAULT NULL COMMENT '链接地址id',
    `link_address`       varchar(256) DEFAULT NULL COMMENT '链接地址',
    `img_file_code`      varchar(128) DEFAULT NULL COMMENT '图片文件编码，文件服务器上的文件唯一标识',
    `video_file_code`    varchar(128) DEFAULT NULL COMMENT '视频文件编码，文件服务器上的文件唯一标识',
    `source_type`        varchar(32)  DEFAULT NULL COMMENT '资源类型 1-图片 2-视频',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='广告信息';


-- yst_dev2_ucenter.ad_space definition

CREATE TABLE IF NOT EXISTS `sys_ad_space`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `ad_space_code`      varchar(64)  DEFAULT NULL COMMENT '广告位编码',
    `ad_space_name`      varchar(256) DEFAULT NULL COMMENT '广告位名称',
    `ad_space_desc`      varchar(256) DEFAULT NULL COMMENT '广告位说明',
    `sort_no`            int(11) DEFAULT NULL COMMENT '排序',
    `show_style`         varchar(32)  DEFAULT NULL COMMENT '展现形式(轮播/平铺/弹窗)',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='广告位信息';


-- yst_dev2_ucenter.app_navbar definition

CREATE TABLE IF NOT EXISTS `sys_app_navbar`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `name`               varchar(32)  DEFAULT NULL COMMENT '栏位名称',
    `bar_type`           varchar(32)  DEFAULT NULL COMMENT '栏位类型',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型',
    `window_open_mode`   varchar(32)  DEFAULT NULL COMMENT '打开方式',
    `home_page_flag`     tinyint(1) DEFAULT '0' COMMENT '是否为首页：1是，0否',
    `mall_mode`          varchar(32)  DEFAULT NULL COMMENT '适用商城',
    `link_address`       varchar(32)  DEFAULT NULL COMMENT '链接地址',
    `link_type`          varchar(32)  DEFAULT NULL COMMENT '链接类型',
    `show_flag`          tinyint(1) DEFAULT '1' COMMENT '是否显示：1是，0否',
    `sort`               int(10) DEFAULT NULL COMMENT '排序',
    `upper_bar_id`       bigint(20) DEFAULT NULL COMMENT '上级栏目id',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='APP快捷导航栏信息表';


-- yst_dev2_ucenter.article_category definition

CREATE TABLE IF NOT EXISTS `sys_article_category`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `category_name`      varchar(64)  DEFAULT NULL COMMENT '分类名称',
    `sort_no`            int(11) DEFAULT NULL COMMENT '分类排序',
    `show_flag`          varchar(32)  DEFAULT NULL COMMENT '是否显示 HIDE-隐藏 DISPLAY-显示',
    `pid`                bigint(20) DEFAULT NULL COMMENT '父类id',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    `show_flag_no`       int(5) DEFAULT NULL COMMENT '是否显示序号',
    `root_id`            bigint(20) DEFAULT NULL COMMENT '一级分类id',
    `pid_list`           varchar(256) DEFAULT NULL COMMENT '父类id集合',
    PRIMARY KEY (`id`)
    )   COMMENT='文章分类';


-- yst_dev2_ucenter.article_info definition

CREATE TABLE IF NOT EXISTS `sys_article_info`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `article_author`     varchar(64)  DEFAULT NULL COMMENT '文章作者',
    `article_name`       varchar(256) DEFAULT NULL COMMENT '文章名称',
    `article_code`       varchar(64)  DEFAULT NULL COMMENT '文章编码',
    `sort_no`            int(11) DEFAULT NULL COMMENT '文章排序',
    `show_flag`          varchar(32)  DEFAULT NULL COMMENT '是否显示 HIDE-隐藏 DISPLAY-显示',
    `category_id`        bigint(20) DEFAULT NULL COMMENT '分类id',
    `category_name`      varchar(256) DEFAULT NULL COMMENT '分类名称',
    `article_detail`     longtext COMMENT '文章详情',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    `file_code`          varchar(64)  DEFAULT NULL,
    `file_url`           varchar(256) DEFAULT NULL COMMENT '文章详情url',
    PRIMARY KEY (`id`)
    )   COMMENT='文章信息';


-- yst_dev2_ucenter.common_search definition

CREATE TABLE IF NOT EXISTS `sys_common_search`
(
    `id`                    bigint(20) NOT NULL COMMENT '记录唯一ID',
    `common_search_id`      varchar(32)   DEFAULT NULL COMMENT '通查ID',
    `common_search_name`    varchar(32)   DEFAULT NULL COMMENT '通查名称',
    `common_search_content` varchar(512)  DEFAULT NULL COMMENT '通查内容',
    `common_search_param`   varchar(512)  DEFAULT NULL COMMENT '通查参数',
    `connection_name`       varchar(256)  DEFAULT NULL COMMENT '连接名字',
    `database_type`         varchar(16)   DEFAULT NULL COMMENT '数据库类型',
    `cache_flag`            tinyint(1) DEFAULT '0' COMMENT '是否缓存：1是，0否',
    `cache_live_time`       decimal(8, 0) DEFAULT NULL COMMENT '缓存存活时间',
    `sub_search`            varchar(64)   DEFAULT NULL COMMENT '子查询',
    `tenant_id`             bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    `user_name`             varchar(32)   DEFAULT NULL COMMENT '用户名',
    `password`              varchar(32)   DEFAULT NULL COMMENT '密码',
    PRIMARY KEY (`id`)
    )   COMMENT='通用查询';


-- yst_dev2_ucenter.file_info definition

CREATE TABLE IF NOT EXISTS `sys_file_info`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `url`                varchar(255) DEFAULT NULL COMMENT '链接',
    `file_code`          varchar(255) DEFAULT NULL COMMENT '编码',
    `source_id`          bigint(20) DEFAULT NULL COMMENT '来源id',
    `source_type`        varchar(255) DEFAULT NULL COMMENT '来源类型',
    `file_name`          varchar(255) DEFAULT NULL COMMENT '文件名称',
    `old_file_name`      varchar(255) DEFAULT NULL COMMENT '原始文件名称',
    `file_size`          varchar(255) DEFAULT NULL COMMENT '文件大小',
    `file_info`          varchar(255) DEFAULT NULL COMMENT '文件内容',
    `original_name`      varchar(256) DEFAULT NULL COMMENT '文件原名称',
    `suffix`             varchar(256) DEFAULT NULL COMMENT '文件名后缀',
    `mime_type`          varchar(256) DEFAULT NULL COMMENT '文件内容类型',
    `file_type`          varchar(256) DEFAULT NULL COMMENT '常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见',
    `upload_time`        datetime(6) DEFAULT NULL COMMENT '上传时间',
    `file_path`          varchar(256) DEFAULT NULL COMMENT '文件路径',
    `width`              int(10) DEFAULT NULL COMMENT '宽度，图片时有值',
    `height`             int(10) DEFAULT NULL COMMENT '高度，图片时有值',
    `url_preview`        varchar(256) DEFAULT NULL COMMENT '文件预览url',
    `uri_down_load`      varchar(256) DEFAULT NULL COMMENT '文件下载uri',
    `url_delete`         varchar(256) DEFAULT NULL COMMENT '文件删除url',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='文件信息';


-- yst_dev2_ucenter.message_info definition

CREATE TABLE IF NOT EXISTS `sys_message_info`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `message_title`      varchar(256) DEFAULT NULL COMMENT '消息标题',
    `category_code`      varchar(256) DEFAULT NULL COMMENT '消息分类code',
    `publish_status`     char(1)      DEFAULT NULL COMMENT '发布状态 0-未发布 1-已发布',
    `message_detail`     longtext COMMENT '消息描述',
    `file_code`          varchar(256) DEFAULT NULL COMMENT '附件编码，文件服务器上的文件唯一标识',
    `total_count`        int(10) DEFAULT NULL COMMENT '总人数',
    `read_count`         int(10) DEFAULT '0' COMMENT '已阅读人数',
    `read_process`       varchar(16)  DEFAULT NULL COMMENT '阅读进度',
    `publish_time`       datetime     DEFAULT NULL COMMENT '发布时间',
    `record_id`          varchar(256) DEFAULT NULL COMMENT '消息记录标识',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    `file_name`          varchar(256) DEFAULT NULL COMMENT '附件名称',
    PRIMARY KEY (`id`)
    )   COMMENT='消息信息';


-- yst_dev2_ucenter.message_receiver definition

CREATE TABLE IF NOT EXISTS `sys_message_receiver`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `message_id`         bigint(20) DEFAULT NULL COMMENT '消息id',
    `emp_id`             bigint(20) DEFAULT NULL COMMENT '员工id',
    `emp_no`             varchar(64)  DEFAULT NULL COMMENT '账号',
    `emp_name`           varchar(64)  DEFAULT NULL COMMENT '员工姓名',
    `mobile`             varchar(64)  DEFAULT NULL COMMENT '手机号',
    `dept_name`          varchar(64)  DEFAULT NULL COMMENT '部门名称',
    `read_status`        char(1)      DEFAULT NULL COMMENT '-1-草稿 0-未阅读 1-已阅读 阅读状态',
    `read_time`          datetime     DEFAULT NULL COMMENT '阅读时间',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='消息接收者信息';


-- yst_dev2_ucenter.pc_bar definition

CREATE TABLE IF NOT EXISTS `sys_pc_bar`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `name`               varchar(32)  DEFAULT NULL COMMENT '栏位名称',
    `bar_type`           varchar(32)  DEFAULT NULL COMMENT '栏位类型',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型',
    `window_open_mode`   varchar(32)  DEFAULT NULL COMMENT '打开方式',
    `home_page_flag`     tinyint(1) DEFAULT '0' COMMENT '是否为首页：1是，0否',
    `mall_mode`          varchar(32)  DEFAULT NULL COMMENT '适用商城',
    `link_address`       varchar(255) DEFAULT NULL COMMENT '链接地址',
    `link_type`          varchar(32)  DEFAULT NULL COMMENT '链接类型',
    `show_flag`          tinyint(1) DEFAULT '1' COMMENT '是否显示：1是，0否',
    `sort`               int(10) DEFAULT NULL COMMENT '排序',
    `upper_bar_id`       bigint(20) DEFAULT NULL COMMENT '上级栏目id',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='网站外观配置信息表';


-- yst_dev2_ucenter.receipt_source_config definition

CREATE TABLE IF NOT EXISTS `sys_receipt_source_config`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `source_no`          varchar(32)  DEFAULT NULL COMMENT '来源编号',
    `source_name`        varchar(128) DEFAULT NULL COMMENT '来源名称',
    `source_type`        varchar(32)  DEFAULT NULL COMMENT '来源类型',
    `connect_url`        varchar(128) DEFAULT NULL COMMENT '接口URL',
    `param_value`        varchar(128) DEFAULT NULL COMMENT '接口参数',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='单据来源配置';


-- yst_dev2_ucenter.receipt_source_config_detail definition

CREATE TABLE IF NOT EXISTS `sys_receipt_source_config_detail`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `source_no`          varchar(32)  DEFAULT NULL COMMENT '来源编号',
    `field_name`         varchar(128) DEFAULT NULL COMMENT '透出字段',
    `field_definition`   varchar(32)  DEFAULT NULL COMMENT '字段定义',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='单据来源配置明细';



-- yst_dev2_ucenter.website_appearance definition

CREATE TABLE IF NOT EXISTS `sys_website_appearance`
(
    `id`                  bigint(20) NOT NULL COMMENT '记录唯一ID',
    `title`               varchar(32)   DEFAULT NULL COMMENT '浏览器标题',
    `type`                varchar(32)   DEFAULT NULL COMMENT '网站类型',
    `browser_logo_id`     varchar(64)   DEFAULT NULL COMMENT '浏览器logo图片id',
    `webpage_logo_id`     varchar(64)   DEFAULT NULL COMMENT '网页logo图片id',
    `theme_color`         varchar(20)   DEFAULT NULL COMMENT '网站主题色',
    `font_size`           int(10) DEFAULT '12' COMMENT '字体大小',
    `language`            varchar(32)   DEFAULT 'zh_CN' COMMENT '默认语言，默认中文',
    `multi_language_flag` tinyint(1) DEFAULT '1' COMMENT '是否支持多语言：1是，0否',
    `menu_unfold_flag`    tinyint(1) DEFAULT '1' COMMENT '菜单是否展开：1是，0否',
    `menu_width`          int(10) DEFAULT NULL COMMENT '菜单区域宽度',
    `description`         varchar(2048) DEFAULT NULL COMMENT '网站描述',
    `tenant_id`           bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
    )   COMMENT='网站外观配置信息表';


-- yst_dev2_ucenter.website_bar definition

CREATE TABLE IF NOT EXISTS `sys_website_bar`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `bar_name`           varchar(32)  DEFAULT NULL COMMENT '栏位名称',
    `bar_type`           varchar(32)  DEFAULT NULL COMMENT '栏位类型',
    `bar_code`           varchar(32)  DEFAULT NULL COMMENT '栏位编码',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型',
    `window_open_mode`   varchar(32)  DEFAULT NULL COMMENT '打开方式',
    `home_page_flag`     tinyint(1) DEFAULT '0' COMMENT '是否为首页：1是，0否',
    `mall_mode`          varchar(32)  DEFAULT NULL COMMENT '适用商城',
    `link_address`       varchar(255) DEFAULT NULL COMMENT '链接地址',
    `link_address_id`    bigint(20) DEFAULT NULL COMMENT '链接地址',
    `link_type`          varchar(32)  DEFAULT NULL COMMENT '链接类型',
    `show_flag`          tinyint(1) DEFAULT '1' COMMENT '是否显示：1是，0否',
    `sort_no`            int(10) DEFAULT NULL COMMENT '排序',
    `pid`                bigint(20) DEFAULT NULL COMMENT '上级id',
    `tenant_id`          bigint(20) DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20) DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20) DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20) DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20) DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20) DEFAULT NULL COMMENT '数据归属公司id',
    `p_name`             varchar(256) DEFAULT NULL COMMENT '上级栏目名称',
    PRIMARY KEY (`id`)
    )   COMMENT='网站栏目配置';