alter table sys_business_operation_param
    add column paging_result bit default 0 comment '是否是PagingVO的参数';
CREATE TABLE `sys_data_selector_group`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `group_code`         varchar(255) NOT NULL COMMENT '分组编码',
    `group_name`         varchar(255) NOT NULL COMMENT '分组名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '启用状态',
    `sort_no`            int          DEFAULT '0' COMMENT '排序',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='数据选择器分组';
CREATE TABLE `sys_data_selector`
(
    `id`                  bigint       NOT NULL COMMENT '记录唯一ID',
    `group_code`          varchar(255) DEFAULT NULL COMMENT '分组编码',
    `selector_code`       varchar(255) NOT NULL COMMENT '选择器编码',
    `selector_name`       varchar(255) DEFAULT NULL COMMENT '选择器名称',
    `enabled`             bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `component`           bit(1)       DEFAULT b'0' COMMENT '是否是公共组件',
    `component_code`      varchar(255) DEFAULT NULL COMMENT '组件编码',
    `data_api`            varchar(255) DEFAULT NULL COMMENT '数据接口API',
    `data_api_method`     varchar(255) DEFAULT NULL COMMENT '数据接口请求方式',
    `data_style`          varchar(255) DEFAULT NULL COMMENT '数据格式',
    `api_headers_json`    longtext COMMENT '数据接口请求头',
    `api_req_body_json`   longtext COMMENT '数据接口请求体',
    `api_req_params_json` longtext COMMENT '数据接口查询参数',
    `data_fields_str`     varchar(255) DEFAULT NULL COMMENT '使用的数据字段',
    `value_num_limit`     int          DEFAULT '-1' COMMENT '值数量限制',
    `ext_attributes_json` longtext COMMENT '扩展属性',
    `tenant_id`           bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_dataselect_group` (`group_code`),
    KEY `idx_dataselect_code` (`selector_code`)
) COMMENT ='数据选择器';
CREATE TABLE `sys_data_relation`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(255) NOT NULL COMMENT '关系编码',
    `name`               varchar(255) NOT NULL COMMENT '关系名称',
    `bo_code`            varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `ref_bo_code`        varchar(255) DEFAULT NULL COMMENT '关联的业务对象编码',
    `data_selector_code` varchar(255) DEFAULT NULL COMMENT '数据选择器编码',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_datarelation_code` (`code`)
) COMMENT ='数据关系';
CREATE TABLE `sys_data_relation_cat`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `dr_code`            varchar(255) NOT NULL COMMENT '数据关系编码',
    `cat_code`           varchar(255) NOT NULL COMMENT '分类编码',
    `cat_name`           varchar(255) NOT NULL COMMENT '分类名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_datarelation_cat_dr` (`dr_code`)
) COMMENT ='数据关系的分类';
CREATE TABLE `sys_data_relation_inst`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `dr_code`            varchar(255) NOT NULL COMMENT '数据关系编码',
    `cat_code`           varchar(255) DEFAULT NULL COMMENT '分类编码',
    `data_key`           varchar(255) DEFAULT NULL COMMENT '主数据的标识',
    `data_attribute`     varchar(255) DEFAULT NULL COMMENT '主数据的检索属性',
    `data_ext_json`      longtext COMMENT '主数据的扩展信息',
    `ref_data_key`       varchar(255) DEFAULT NULL COMMENT '关联数据的标识',
    `ref_data_attribute` varchar(255) DEFAULT NULL COMMENT '关联数据的检索属性',
    `ref_data_ext_json`  longtext COMMENT '关联数据的扩展信息',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_datarelation_inst_dr` (`dr_code`),
    KEY `idx_datarelation_inst_datak` (`data_key`),
    KEY `idx_datarelation_inst_cat` (`cat_code`),
    KEY `idx_datarelation_inst_attr` (`data_attribute`),
    KEY `idx_datarelation_inst_datakr` (`ref_data_key`)
) COMMENT ='业务对象与数据关联的配置';
alter table sys_tmpl_import_record
    add column custom_tip_msg varchar(255) comment '自定义提示信息';
ALTER TABLE sys_role_data_permission
    MODIFY COLUMN bs1 longtext NULL COMMENT '特用字段1';
ALTER TABLE sys_role_data_permission
    MODIFY COLUMN bs2 longtext NULL COMMENT '特用字段2';
ALTER TABLE sys_role_data_permission
    MODIFY COLUMN bs3 longtext NULL COMMENT '特用字段3';
CREATE TABLE `sys_permission_res`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `res_type`           varchar(255) NOT NULL COMMENT '资源类型',
    `res_id`             varchar(255) NOT NULL COMMENT '资源标识',
    `owner_type`         varchar(255) NOT NULL COMMENT '持有者类型',
    `owner_id`           varchar(255) NOT NULL COMMENT '持有者标识',
    `assigner_type`      varchar(255) NOT NULL COMMENT '分配者类型',
    `assigner_id`        varchar(255) NOT NULL COMMENT '分配者标识',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_permission_res_res` (`res_id`),
    KEY `idx_permission_res_owner` (`owner_id`),
    KEY `idx_permission_res_assigner` (`assigner_id`)
) COMMENT ='权限资源配置';

drop table `sys_sub_user`;
CREATE TABLE `sys_sub_user`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `sub_user_id`        bigint NOT NULL COMMENT '子账号ID',
    `type`               varchar(255) DEFAULT NULL COMMENT '归属类型',
    `type_id`            varchar(255) DEFAULT NULL COMMENT '归属类型标识',
    `permission_type`    varchar(255) DEFAULT NULL COMMENT '权限类型',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sub_user_user` (`type_id`),
    KEY `idx_sub_user_subuser` (`sub_user_id`)
) COMMENT ='系统子账号';