package com.elitescloud.cloudt.comm.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author shihao.ma
 * 2020/7/2
 */
@Entity
@Table(name = "com_payment_term")
@Comment("支付条款 币种 此表使用CODE来引用，不使用ID")
@Data
@Accessors(chain = true)
public class ComPaymentTermDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 2650690565824522531L;

//    @Comment("租户ID")
//    @Column(name = "tenant_id"")
//    private Integer tenantId;

    @Comment("代码")
    @Column()
    private String ptCode;

    @Comment("名称")
    @Column()
    private String ptName;

    @Comment("天数")
    @Column()
    private Integer days;

    @Comment("基于日期类型")
    @Column()
    private String baseDayType;

    @Comment("日期计算方式 是否含工作日")
    @Column()
    private String dayCalcMethod;

    @Comment("生效日期")
    @Column()
    private LocalDateTime validFrom;

    @Comment("失效日期")
    @Column()
    private LocalDateTime validTo;

    @Comment("是否有效")
    @Column()
    private Integer enableFlag;

    @Comment("对账报账编码")
    @Column()
    private String accountCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComPaymentTermDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComPaymentTermDO entity = (ComPaymentTermDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
