//package com.elitescloud.cloudt.log.controller;
//
//import com.elitescloud.boot.util.JSONUtil;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//import com.elitescloud.cloudt.log.model.vo.param.OperationConfigQueryParam;
//import com.elitescloud.cloudt.log.model.vo.resp.OperationConfigVO;
//import com.elitescloud.cloudt.log.service.OperationConfigService;
//import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiImplicitParam;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.redis.core.RedisTemplate;
//import org.springframework.web.bind.annotation.*;
//
//import javax.validation.Valid;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
///**
// * @author James.Huang
// * @version 2022.1
// * @date 2023/6/27 14:01
// * @Description:
// */
//@RestController
//@RequestMapping(value = "/operationConfig")
//@Api(tags = "操作日志配置")
//public class OperationConfigController {
//
//    @Autowired
//    private OperationConfigService operationConfigService;
//    @Autowired
//    private RedisTemplate redisTemplate;
//
//
//
//    @ApiOperation(value = "保存操作日志配置")
//    @ApiOperationSupport(order = 1)
//    @PostMapping(value = "/save")
//    public ApiResult<Long> save(@Valid @RequestBody OperationConfigVO ocVO){
//
//        return operationConfigService.saveOperConfig(ocVO);
//    }
//
//    @ApiOperation(value = "获取操作日志配置详情")
//    @ApiOperationSupport(order = 2)
//    @GetMapping(value = "/get/{id}")
//    public ApiResult<OperationConfigVO> detail(@PathVariable("id") Long id){
//
//        return operationConfigService.getOperConfig(id);
//    }
//
//    @ApiOperation(value = "获取操作日志配置所有列表")
//    @ApiOperationSupport(order = 3)
//    @GetMapping(value = "/getAllOperationConfig")
//    public ApiResult<List<OperationConfigVO>> getAllOperationConfig(){
//
//        return ApiResult.ok(operationConfigService.findOperationConfigList());
//    }
//
//    @ApiOperation(value = "从redis获取操作日志配置信息")
//    @ApiOperationSupport(order = 4)
//    @GetMapping(value = "/getOperationConfigInfo")
//    public ApiResult<Boolean> getOperationConfigInfo(
//            @ApiParam(name = "operationUrl", value = "请求地址", required = false) @RequestParam(value = "operationUrl", required = false) String operationUrl
//
//    ){
//        String operationConfigKey="OPERATION-CONFIG-KEY";
//        boolean isStandkey=redisTemplate.opsForHash().hasKey(operationConfigKey,operationUrl);
//
//        System.out.println("isStandkey==="+isStandkey);
//
//        if(isStandkey){
//            String ocObject= (String) redisTemplate.opsForHash().get(operationConfigKey,operationUrl);
//            Map<String,Object> ocMap= JSONUtil.json2Obj(ocObject,HashMap.class);
//            for(Object obj:ocMap.values()){
//                System.out.println("obj==="+obj);
//            }
//
//        }
//
//        return ApiResult.ok(isStandkey);
//    }
//    /**
//     * 搜索日志
//     *
//     * @param queryParam 查询参数
//     * @return 日志列表
//     */
//    @PostMapping(value = "/search")
//    @ApiOperation(value = "搜索操作日志配置")
//    @ApiOperationSupport(order = 5)
//    public ApiResult<PagingVO<OperationConfigVO>> search(@RequestBody OperationConfigQueryParam queryParam) {
//
//        return operationConfigService.page(queryParam);
//    }
//
//    @ApiOperation(value = "删除操作日志配置")
//    @ApiOperationSupport(order = 6)
//    @ApiImplicitParam(name = "id", value = "操作日志配置的ID", required = true, dataType = "int")
//    @DeleteMapping(value = "/delete")
//    public ApiResult<Long> deleteValue(
//            @ApiParam(name = "id", value = "操作日志配置id", required = true) @RequestParam(value = "id", required = true) Long id
//    ) {
//
//        return operationConfigService.deleteValue(id);
//    }
//
//}
