package com.elitescloud.cloudt.log.model.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 查询日志结果.
 *
 * @author Kaiser（wang shao）
 * 2021/07/31
 */
@Data
@ApiModel(description = "日志记录")
public class LogStashRecordRespVO implements Serializable {
    private static final long serialVersionUID = 4925719981564992551L;

    @ApiModelProperty(value = "所属环境", position = 0)
    private String preIndex;

    @ApiModelProperty(value = "应用名称", position = 1)
    private String appName;

    @ApiModelProperty(value = "日志级别", position = 2)
    private String logLevel;

    @ApiModelProperty(value = "日志内容", position = 3)
    private String msg;

    @ApiModelProperty(value = "日志时间", position = 4)
    private LocalDateTime time;

    @ApiModelProperty(value = "完整的日志内容", position = 5)
    private String message;
}
