package com.elitescloud.cloudt.system.component.rest;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.component.param.SysUserComponentPagingParam;
import com.elitescloud.cloudt.system.component.service.SysComponentService;
import com.elitescloud.cloudt.system.service.vo.component.SysUserComponentPagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Chris
 * 2021-06-02
 */
@RestController
@RequestMapping("/sys/component")
@RequiredArgsConstructor
@Api(value = "系统域-公共组件接口", tags = {"系统域-公共组件接口"})
public class SysComponentController {

    private final SysComponentService sysComponentService;

    @PostMapping("/user/paging")
    @ApiOperation("获取用户分页数据-放大镜组件")
    public ApiResult<PagingVO<SysUserComponentPagingVO>> findUserComPaging(@RequestBody SysUserComponentPagingParam param) {
        return ApiResult.ok(sysComponentService.findSysUserPagingByParam(param));
    }

}
