package com.elitescloud.cloudt.system.config.support.userouterapp;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.common.WechatAppProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatOpenIdAndUnionId;
import com.elitescloud.cloudt.system.service.common.service.UserOuterAppProvider;
import com.elitescloud.cloudt.system.service.dto.SysUserOuterAppDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 微信的用户信息提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/12
 */
@Component
@ConditionalOnMissingBean(name = "wechatUserOuterAppProvider")
public class WechatUserOuterAppProvider implements UserOuterAppProvider {
    private static final Logger logger = LoggerFactory.getLogger(WechatUserOuterAppProvider.class);

    @Autowired
    private WechatAppProvider appProvider;
    @Autowired
    private WechatTemplate template;

    @Override
    public SysUserOuterAppDTO get(String appId, HttpServletRequest request) {
        var app = appProvider.getApp(appId);
        if (app == null) {
            return null;
        }

        // 授权码
        String code = request.getParameter("code");
        if (CharSequenceUtil.isBlank(code)) {
            logger.info("微信授权码为空");
            return null;
        }

        // 根据授权码获取用户信息
        WechatOpenIdAndUnionId info = template.getOpenId(appId, code);
        if (info == null) {
            return null;
        }

        SysUserOuterAppDTO userOuterAppDTO = new SysUserOuterAppDTO();
        userOuterAppDTO.setOpenId(info.getOpenId());
        userOuterAppDTO.setUnionId(info.getUnionId());
        return userOuterAppDTO;
    }
}
