package com.elitescloud.cloudt.system.controller.mng.sys;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.save.sys.AuthUserFormVO;
import com.elitescloud.cloudt.system.service.AuthUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;

/**
 * 用户认证.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/10
 */
@Api(tags = "用户认证", hidden = true)
@RestController
@RequestMapping(value = "/mng/auth", produces = MediaType.APPLICATION_JSON_VALUE)
@ApiIgnore
@Validated
public class AuthUserMngController {
    static {
        InterceptUri.addAllowUri(Set.of("/mng/auth/**"));
    }

    private AuthUserService authUserService;

    @ApiOperation(value = "获取token")
    @PostMapping(value = "/token", consumes = MediaType.APPLICATION_FORM_URLENCODED_VALUE)
    public ApiResult<OAuthToken> getToken(HttpServletRequest request, HttpServletResponse response,
                                          AuthUserFormVO formVO) {
        return authUserService.authenticateForEncoded(request, response, formVO.getIdType(), formVO.getId(), formVO.getCipherType());
    }

    @Autowired
    public void setAuthUserService(AuthUserService authUserService) {
        this.authUserService = authUserService;
    }
}
