package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.common.OwnerType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 前端表格配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/20
 */
@Entity
@org.hibernate.annotations.Table(appliesTo = "sys_front_table_cfg")
@Table(name = "sys_front_table_cfg", indexes = {
        @Index(name = "idx_front_table_cfg_code", columnList = "tableCode"),
        @Index(name = "idx_front_table_cfg_owner", columnList = "ownerId"),
})
@Comment("前端表格配置")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysFrontTableCfgDO extends BaseModel {
    private static final long serialVersionUID = -1444114186258980379L;

    @Comment("表格编码")
    @Column(nullable = false)
    private String tableCode;

    @Comment("拥有者ID")
    @Column(nullable = false)
    private Long ownerId;

    @Comment("拥有者类型")
    @Column(nullable = false)
    @Enumerated(value = EnumType.STRING)
    private OwnerType ownerType;

    @Comment("配置内容")
    @Column()
    @Lob
    private String config;
}
