package com.elitescloud.cloudt.system.model.vo.query.org;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Set;

/**
 * 组织分页查询.
 *
 * @author Kaiser（wang shao）
 * 2022/10/28
 */
@Data
@ApiModel(description = "组织分页查询")
public class OrgPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 40863292711711116L;

    /**
     * 上级组织编码
     */
    @ApiModelProperty(value = "上级组织编码", position = 1)
    private String parentCode;

    /**
     * 所属公司ID
     */
    @ApiModelProperty(value = "所属公司ID", position = 1)
    private Long ouId;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织编码", position = 2)
    private String code;

    @ApiModelProperty(value = "外部组织编码", position = 4)
    private String outerCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", position = 3)
    private String name;

    /**
     * 是否实体组织
     */
    @ApiModelProperty(value = "是否行政组织", position = 4)
    private Boolean executive;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "组织类型[UDC]cloudt-system:orgType", position = 5)
    private String type;
    /**
     * 组织类型
     */
    @ApiModelProperty(value = "组织类型列表[UDC]cloudt-system:orgType", position = 5)
    private Set<String> types;

    /**
     * 是否实体组织
     */
    @ApiModelProperty(value = "是否实体组织", position = 6)
    private Boolean entity;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;
}
