package com.elitescloud.cloudt.system.model.vo.resp.businessobject;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务操作分页信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/14
 */
@Getter
@Setter
@ApiModel(description = "业务操作分页信息")
public class BusinessOperationPageRespVO implements Serializable {
    private static final long serialVersionUID = 2249319558675889317L;

    @ApiModelProperty(value = "业务操作ID")
    private Long id;

    @ApiModelProperty(value = "业务对象ID")
    private Long businessObjectId;

    @ApiModelProperty(value = "操作编码")
    private String operationCode;

    @ApiModelProperty(value = "操作名称")
    private String operationName;

    @ApiModelProperty(value = "默认名称")
    private String defaultName;

    @ApiModelProperty(value = "操作描述")
    private String detail;

    /**
     * 取值：{@link com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum}
     */
    @ApiModelProperty(value = "操作类型")
    private String operationType;
    @ApiModelProperty(value = "操作类型名称")
    private String operationTypeName;

    @ApiModelProperty(value = "支持权限")
    private Boolean permissionEnabled;

    @ApiModelProperty(value = "关联的权限编码")
    private String permissionRef;

    @ApiModelProperty(value = "自动过滤权限字段")
    private Boolean fieldPermissionAutoFilter;

    @ApiModelProperty(value = "API的URL")
    private String apiUrl;

    @ApiModelProperty(value = "API的方法")
    private String apiMethod;

    @ApiModelProperty(value = "关联菜单数量")
    private Long menuNum;
}
