package com.elitescloud.cloudt.system.model.vo.resp.common;

import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 菜单树节点信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/28
 */
@Getter
@Setter
@ApiModel(description = "菜单树节点信息")
public class CommonMenuTreeNodeRespVO extends TreeRespParam<CommonMenuTreeNodeRespVO> {
    private static final long serialVersionUID = -1261332878064025500L;

    /**
     * 取值：{@link PlatformAppMenusTypeEnum}
     */
    @ApiModelProperty(value = "菜单类型，（MENUS_TYPE_SYS-系统菜单、MENUS_TYPE_BUS-业务菜单）", position = 11)
    private String menusType;
    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 12)
    private String nodeType;

    @ApiModelProperty(value = "所属应用编码", position = 13)
    private String appCode;

    @ApiModelProperty(value = "菜单图标", position = 14)
    private String menusIcon;
    @ApiModelProperty(value = "路由地址", position = 5)
    private String menusRoute;

    @ApiModelProperty(value = "是否隐藏", position = 15)
    private Boolean hidden;

    @ApiModelProperty(value = "是否启用", position = 16)
    private Boolean enabled;
}
