package com.elitescloud.cloudt.system.model.vo.resp.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 税率信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/7/2023
 */
@Data
@ApiModel(description = "税率信息")
public class CommonTaxRateRespVO implements Serializable {
    private static final long serialVersionUID = 837214926392398886L;

    /**
     * 税率编码
     */
    @ApiModelProperty(value = "税率编码", position = 1)
    private String taxRateNo;

    /**
     * 税率类型
     */
    @ApiModelProperty(value = "税率类型，UDC[cloudt-system:taxRateType]", position = 2)
    private String taxRateType;
    private String taxRateTypeName;

    /**
     * 税率值
     */
    @ApiModelProperty(value = "税率值", position = 3)
    private BigDecimal taxRateValue;

    /**
     * 税率说明
     */
    @ApiModelProperty(value = "税率说明", position = 4)
    private String taxRateDesc;
}
