package com.elitescloud.cloudt.system.model.vo.resp.datarelation;

import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 数据关系配置信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Getter
@Setter
@ApiModel(description = "数据关系配置信息")
public class DataRelationConfigRespVO implements Serializable {
    private static final long serialVersionUID = -6428673130091963575L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "数据关系编码", position = 2)
    private String code;

    @ApiModelProperty(value = "数据关系名称", position = 3)
    private String name;

    @ApiModelProperty(value = "主业务对象编码", position = 4)
    private String boCode;

    @ApiModelProperty(value = "主业务对象名称", position = 4)
    private String boName;

    @ApiModelProperty(value = "关联的主业务对象编码", position = 5)
    private String refBoCode;

    @ApiModelProperty(value = "关联业务对象名称", position = 5)
    private String refBoName;

    @ApiModelProperty(value = "分类", position = 11)
    private List<Cat> cats;

    @ApiModelProperty(value = "数据选择器配置", position = 12)
    private CommonDataSelectorRespVO dataSelector;

    @Getter
    @Setter
    @ApiModel(value = "DataRelationConfigRespVO_Cat", description = "数据关系的分类")
    public static class Cat implements Serializable {
        private static final long serialVersionUID = -5836087492481620372L;

        @ApiModelProperty(value = "分类编码", position = 1)
        private String catCode;

        @ApiModelProperty(value = "分类名称", position = 2)
        private String catName;
    }
}
