package com.elitescloud.cloudt.system.model.vo.resp.devops;

import com.elitescloud.boot.core.support.common.param.ServiceInstanceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;

/**
 * 服务实例信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
@Getter
@Setter
@ApiModel(description = "服务实例信息")
public class ServiceInstanceInfoRespVO implements Serializable {
    private static final long serialVersionUID = -7745861876378055716L;

    @ApiModelProperty(value = "Java版本")
    private String javaVersion;

    @ApiModelProperty(value = "SpringBoot版本")
    private String springBootVersion;

    @ApiModelProperty(value = "云梯架构版本")
    private String cloudtBootVersion;

    @ApiModelProperty(value = "项目版本")
    private String projectVersion;

    @ApiModelProperty(value = "运行时信息")
    private RuntimeInfo runtimeInfo;

    @ApiModelProperty(value = "系统属性")
    private Map<String, Object> sysProperties;

    @ApiModelProperty(value = "环境变量")
    private Map<String, Object> sysEnv;

    @ApiModelProperty(value = "激活的配置文件")
    private String[] activeProfiles;

    @ApiModelProperty(value = "配置信息")
    private List<PropertySource> propertySources;

    @Getter
    @Setter
    @ApiModel(value = "ServiceInstanceInfoRespVO_PropertySource", description = "服务实例信息")
    public static class PropertySource implements Serializable {
        private static final long serialVersionUID = -8813008047068630547L;

        @ApiModelProperty(value = "环境变量")
        private String name;

        @ApiModelProperty(value = "资源名称")
        private String sourceName;

        @ApiModelProperty(value = "属性")
        private Map<String, Object> properyMap;
    }

    @Getter
    @Setter
    @ApiModel(value = "ServiceInstanceInfoRespVO_RuntimeInfo", description = "运行时信息")
    public static class RuntimeInfo implements Serializable {
        private static final long serialVersionUID = -2807220367727210835L;

        @ApiModelProperty(value = "最大内存")
        private String maxMemory;

        @ApiModelProperty(value = "总内存")
        private String totalMemory;

        @ApiModelProperty(value = "空闲内存")
        private String freeMemory;

        @ApiModelProperty(value = "可用内存")
        private String usableMemory;

        @ApiModelProperty(value = "处理器数量")
        private Integer processors;

        @ApiModelProperty(value = "jvm参数")
        private List<String> jvmArgs;

        @ApiModelProperty(value = "启动时间（毫秒）")
        private Long startTime;

        @ApiModelProperty(value = "在线时间（毫秒）")
        private Long uptime;

        @ApiModelProperty(value = "当前加载的类的数量")
        private Long loadedClassCount;

        @ApiModelProperty(value = "当前线程数")
        private Long threadCount;

        @ApiModelProperty(value = "最高线程数")
        private Long peakThreadCount;

        public LocalDateTime getStartTime1() {
            if (startTime == null || startTime < 1) {
                return null;
            }
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault());
        }
    }
}
