package com.elitescloud.cloudt.system.model.vo.resp.extend;

import com.elitescloud.cloudt.system.common.ActiveStatus;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.util.AuthAccountResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 16:16
 * @Description:
 */
@Data
@ApiModel("接口定义")
public class InfinityApiDetailVO {

    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台编码")
    private String platformCode;

    @ApiModelProperty(value = "分组id")
    private Long folderId;

    @ApiModelProperty(value = "服务url前缀")
    private String serverUrl;

    @ApiModelProperty(value = "认证方式")
    private String authMethod;

    @ApiModelProperty(value = "认证方式中文")
    private String authMethodName;

    public String getAuthMethodName() {
        return AuthMethod.fromCode(authMethod);
    }

    @ApiModelProperty(value = "认证账号")
    private String authAccount;

    @ApiModelProperty(value = "BasicAuth 认证账号")
    private BasicAuthAccountVO basicAuthAccount;

    public BasicAuthAccountVO getBasicAuthAccount() {
        return AuthAccountResolve.getBasicAuthAccount(authMethod, authAccount);
    }

    @ApiModelProperty(value = "OAuth2.0 认证账号")
    private OAuth2AccountVO oauth2Account;

    public OAuth2AccountVO getOauth2Account() {
        return AuthAccountResolve.getOauth2Account(authMethod, authAccount);
    }

    @ApiModelProperty(value = "接口编码")
    private String apiCode;

    @ApiModelProperty(value = "接口名称")
    private String apiName;

    @ApiModelProperty(value = "接口地址")
    private String apiUrl;

    @ApiModelProperty(value = "请求方式")
    @Enumerated(EnumType.STRING)
    private HttpMethod requestMethod;

    @ApiModelProperty(value = "接口状态")
    private Integer apiStatus;

    @ApiModelProperty(value = "接口状态中文")
    private String apiStatusName;

    public String getApiStatusName() {
        return ActiveStatus.fromCode(apiStatus);
    }

    @ApiModelProperty(value = "header参数")
    private List<FormColumnDefinition> headerParam;

    @ApiModelProperty(value = "查询参数")
    private List<FormColumnDefinition> queryParam;

    @ApiModelProperty(value = "路径参数")
    private List<FormColumnDefinition> pathParam;

    @ApiModelProperty(value = "媒体类型")
    private String mediaType;

    /**
     * <li>mediaType.in(array, object) ==> JsonColumnDefinition</li>
     * <li>mediaType.nin(array, object) ==> List.of(FormColumnDefinition)</li>
     */
    @ApiModelProperty(value = "body参数")
    private Object bodyParam;

    @ApiModelProperty(value = "响应报文结构")
    private JsonColumnDefinition response;

    @ApiModelProperty(value = "响应成功字段")
    private String responseSuccessSpel;

    @ApiModelProperty(value = "响应成功状态值")
    private String responseSuccessStatus;

    @ApiModelProperty(value = "响应错误信息字段")
    private String responseErrorMessageSpel;

    @ApiModelProperty(value = "文档说明(支持markdown)")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;
}
