package com.elitescloud.cloudt.system.model.vo.resp.extend;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

import java.util.Optional;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:08
 * @Description:
 */
public class InfinityLogVO {
    @ApiModelProperty("服务端地址")
    private String serverUrl;
    @ApiModelProperty("接口地址")
    private String apiUrl;
    @ApiModelProperty("接口完整地址")
    private String uri;
    @ApiModelProperty("请求方式")
    private HttpMethod requestMethod;
    @ApiModelProperty("header参数")
    private MultiValueMap<String, String> headerParam = new LinkedMultiValueMap();
    @ApiModelProperty("查询参数")
    private MultiValueMap<String, String> queryParam = new LinkedMultiValueMap();
    @ApiModelProperty("body参数")
    private Object bodyParam;
    @ApiModelProperty("客户端IP")
    private String addressIp;
    @ApiModelProperty("请求时间")
    private String requestTime;
    @ApiModelProperty("响应时间")
    private String responseTime;
    @ApiModelProperty("响应时长：单位毫秒")
    private Long spendTime;
    @ApiModelProperty("是否请求成功")
    private Boolean requestSuccess;
    @ApiModelProperty("请求失败信息")
    private String requestFailMessage;
    @ApiModelProperty("响应体")
    private Object responseBody;
    @ApiModelProperty("是否响应成功")
    private Boolean responseSuccess;
    @ApiModelProperty("响应失败信息")
    private String responseFailMessage;
    @ApiModelProperty("日志链路ID")
    private String traceId;
    @ApiModelProperty("外部应用名称")
    private String targetApp;
    @ApiModelProperty("租户编码")
    private String tenantCode;
    @ApiModelProperty("业务类型")
    private String businessType;
    @ApiModelProperty("业务类型中文")
    private String businessTypeName;
    @ApiModelProperty("业务数据key")
    private String businessKey;

    public void addQueryParam(String name, Object... values) {
        Assert.notNull(name, "Name must not be null");
        if (!ObjectUtils.isEmpty(values)) {
            Object[] var3 = values;
            int var4 = values.length;

            for (int var5 = 0; var5 < var4; ++var5) {
                Object value = var3[var5];
                String valueAsString = this.getQueryParamValue(value);
                this.queryParam.add(name, valueAsString);
            }
        } else {
            this.queryParam.add(name, null);
        }

    }

    @Nullable
    private String getQueryParamValue(@Nullable Object value) {
        if (value != null) {
            return value instanceof Optional ?
                    (String) ((Optional) value).map(Object::toString).orElse((Object) null) : value.toString();
        } else {
            return null;
        }
    }

    public void addQueryParams(@Nullable MultiValueMap<String, String> params) {
        if (params != null) {
            this.queryParam.addAll(params);
        }

    }

    public InfinityLogVO() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getRequestMethod() {
        return this.requestMethod;
    }

    public MultiValueMap<String, String> getHeaderParam() {
        return this.headerParam;
    }

    public MultiValueMap<String, String> getQueryParam() {
        return this.queryParam;
    }

    public Object getBodyParam() {
        return this.bodyParam;
    }

    public String getAddressIp() {
        return this.addressIp;
    }

    public String getRequestTime() {
        return this.requestTime;
    }

    public String getResponseTime() {
        return this.responseTime;
    }

    public Long getSpendTime() {
        return this.spendTime;
    }

    public Boolean getRequestSuccess() {
        return this.requestSuccess;
    }

    public String getRequestFailMessage() {
        return this.requestFailMessage;
    }

    public Object getResponseBody() {
        return this.responseBody;
    }

    public Boolean getResponseSuccess() {
        return this.responseSuccess;
    }

    public String getResponseFailMessage() {
        return this.responseFailMessage;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getTargetApp() {
        return this.targetApp;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getBusinessTypeName() {
        return this.businessTypeName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setServerUrl(final String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setApiUrl(final String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setUri(final String uri) {
        this.uri = uri;
    }

    public void setRequestMethod(final HttpMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setHeaderParam(final MultiValueMap<String, String> headerParam) {
        this.headerParam = headerParam;
    }

    public void setQueryParam(final MultiValueMap<String, String> queryParam) {
        this.queryParam = queryParam;
    }

    public void setBodyParam(final Object bodyParam) {
        this.bodyParam = bodyParam;
    }

    public void setAddressIp(final String addressIp) {
        this.addressIp = addressIp;
    }

    public void setRequestTime(final String requestTime) {
        this.requestTime = requestTime;
    }

    public void setResponseTime(final String responseTime) {
        this.responseTime = responseTime;
    }

    public void setSpendTime(final Long spendTime) {
        this.spendTime = spendTime;
    }

    public void setRequestSuccess(final Boolean requestSuccess) {
        this.requestSuccess = requestSuccess;
    }

    public void setRequestFailMessage(final String requestFailMessage) {
        this.requestFailMessage = requestFailMessage;
    }

    public void setResponseBody(final Object responseBody) {
        this.responseBody = responseBody;
    }

    public void setResponseSuccess(final Boolean responseSuccess) {
        this.responseSuccess = responseSuccess;
    }

    public void setResponseFailMessage(final String responseFailMessage) {
        this.responseFailMessage = responseFailMessage;
    }

    public void setTraceId(final String traceId) {
        this.traceId = traceId;
    }

    public void setTargetApp(final String targetApp) {
        this.targetApp = targetApp;
    }

    public void setTenantCode(final String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setBusinessType(final String businessType) {
        this.businessType = businessType;
    }

    public void setBusinessTypeName(final String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }

    public void setBusinessKey(final String businessKey) {
        this.businessKey = businessKey;
    }

    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof InfinityLogVO)) {
            return false;
        } else {
            InfinityLogVO other = (InfinityLogVO) o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                Object this$spendTime = this.getSpendTime();
                Object other$spendTime = other.getSpendTime();
                if (this$spendTime == null) {
                    if (other$spendTime != null) {
                        return false;
                    }
                } else if (!this$spendTime.equals(other$spendTime)) {
                    return false;
                }

                Object this$requestSuccess = this.getRequestSuccess();
                Object other$requestSuccess = other.getRequestSuccess();
                if (this$requestSuccess == null) {
                    if (other$requestSuccess != null) {
                        return false;
                    }
                } else if (!this$requestSuccess.equals(other$requestSuccess)) {
                    return false;
                }

                Object this$responseSuccess = this.getResponseSuccess();
                Object other$responseSuccess = other.getResponseSuccess();
                if (this$responseSuccess == null) {
                    if (other$responseSuccess != null) {
                        return false;
                    }
                } else if (!this$responseSuccess.equals(other$responseSuccess)) {
                    return false;
                }

                label254:
                {
                    Object this$serverUrl = this.getServerUrl();
                    Object other$serverUrl = other.getServerUrl();
                    if (this$serverUrl == null) {
                        if (other$serverUrl == null) {
                            break label254;
                        }
                    } else if (this$serverUrl.equals(other$serverUrl)) {
                        break label254;
                    }

                    return false;
                }

                label247:
                {
                    Object this$apiUrl = this.getApiUrl();
                    Object other$apiUrl = other.getApiUrl();
                    if (this$apiUrl == null) {
                        if (other$apiUrl == null) {
                            break label247;
                        }
                    } else if (this$apiUrl.equals(other$apiUrl)) {
                        break label247;
                    }

                    return false;
                }

                Object this$uri = this.getUri();
                Object other$uri = other.getUri();
                if (this$uri == null) {
                    if (other$uri != null) {
                        return false;
                    }
                } else if (!this$uri.equals(other$uri)) {
                    return false;
                }

                label233:
                {
                    Object this$requestMethod = this.getRequestMethod();
                    Object other$requestMethod = other.getRequestMethod();
                    if (this$requestMethod == null) {
                        if (other$requestMethod == null) {
                            break label233;
                        }
                    } else if (this$requestMethod.equals(other$requestMethod)) {
                        break label233;
                    }

                    return false;
                }

                label226:
                {
                    Object this$headerParam = this.getHeaderParam();
                    Object other$headerParam = other.getHeaderParam();
                    if (this$headerParam == null) {
                        if (other$headerParam == null) {
                            break label226;
                        }
                    } else if (this$headerParam.equals(other$headerParam)) {
                        break label226;
                    }

                    return false;
                }

                Object this$queryParam = this.getQueryParam();
                Object other$queryParam = other.getQueryParam();
                if (this$queryParam == null) {
                    if (other$queryParam != null) {
                        return false;
                    }
                } else if (!this$queryParam.equals(other$queryParam)) {
                    return false;
                }

                Object this$bodyParam = this.getBodyParam();
                Object other$bodyParam = other.getBodyParam();
                if (this$bodyParam == null) {
                    if (other$bodyParam != null) {
                        return false;
                    }
                } else if (!this$bodyParam.equals(other$bodyParam)) {
                    return false;
                }

                label205:
                {
                    Object this$addressIp = this.getAddressIp();
                    Object other$addressIp = other.getAddressIp();
                    if (this$addressIp == null) {
                        if (other$addressIp == null) {
                            break label205;
                        }
                    } else if (this$addressIp.equals(other$addressIp)) {
                        break label205;
                    }

                    return false;
                }

                label198:
                {
                    Object this$requestTime = this.getRequestTime();
                    Object other$requestTime = other.getRequestTime();
                    if (this$requestTime == null) {
                        if (other$requestTime == null) {
                            break label198;
                        }
                    } else if (this$requestTime.equals(other$requestTime)) {
                        break label198;
                    }

                    return false;
                }

                Object this$responseTime = this.getResponseTime();
                Object other$responseTime = other.getResponseTime();
                if (this$responseTime == null) {
                    if (other$responseTime != null) {
                        return false;
                    }
                } else if (!this$responseTime.equals(other$responseTime)) {
                    return false;
                }

                label184:
                {
                    Object this$requestFailMessage = this.getRequestFailMessage();
                    Object other$requestFailMessage = other.getRequestFailMessage();
                    if (this$requestFailMessage == null) {
                        if (other$requestFailMessage == null) {
                            break label184;
                        }
                    } else if (this$requestFailMessage.equals(other$requestFailMessage)) {
                        break label184;
                    }

                    return false;
                }

                Object this$responseBody = this.getResponseBody();
                Object other$responseBody = other.getResponseBody();
                if (this$responseBody == null) {
                    if (other$responseBody != null) {
                        return false;
                    }
                } else if (!this$responseBody.equals(other$responseBody)) {
                    return false;
                }

                label170:
                {
                    Object this$responseFailMessage = this.getResponseFailMessage();
                    Object other$responseFailMessage = other.getResponseFailMessage();
                    if (this$responseFailMessage == null) {
                        if (other$responseFailMessage == null) {
                            break label170;
                        }
                    } else if (this$responseFailMessage.equals(other$responseFailMessage)) {
                        break label170;
                    }

                    return false;
                }

                Object this$traceId = this.getTraceId();
                Object other$traceId = other.getTraceId();
                if (this$traceId == null) {
                    if (other$traceId != null) {
                        return false;
                    }
                } else if (!this$traceId.equals(other$traceId)) {
                    return false;
                }

                Object this$targetApp = this.getTargetApp();
                Object other$targetApp = other.getTargetApp();
                if (this$targetApp == null) {
                    if (other$targetApp != null) {
                        return false;
                    }
                } else if (!this$targetApp.equals(other$targetApp)) {
                    return false;
                }

                Object this$tenantCode = this.getTenantCode();
                Object other$tenantCode = other.getTenantCode();
                if (this$tenantCode == null) {
                    if (other$tenantCode != null) {
                        return false;
                    }
                } else if (!this$tenantCode.equals(other$tenantCode)) {
                    return false;
                }

                label142:
                {
                    Object this$businessType = this.getBusinessType();
                    Object other$businessType = other.getBusinessType();
                    if (this$businessType == null) {
                        if (other$businessType == null) {
                            break label142;
                        }
                    } else if (this$businessType.equals(other$businessType)) {
                        break label142;
                    }

                    return false;
                }

                label135:
                {
                    Object this$businessTypeName = this.getBusinessTypeName();
                    Object other$businessTypeName = other.getBusinessTypeName();
                    if (this$businessTypeName == null) {
                        if (other$businessTypeName == null) {
                            break label135;
                        }
                    } else if (this$businessTypeName.equals(other$businessTypeName)) {
                        break label135;
                    }

                    return false;
                }

                Object this$businessKey = this.getBusinessKey();
                Object other$businessKey = other.getBusinessKey();
                if (this$businessKey == null) {
                    if (other$businessKey != null) {
                        return false;
                    }
                } else if (!this$businessKey.equals(other$businessKey)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(final Object other) {
        return other instanceof InfinityLogVO;
    }

    public int hashCode() {
        int result = 1;
        Object $spendTime = this.getSpendTime();
        result = result * 59 + ($spendTime == null ? 43 : $spendTime.hashCode());
        Object $requestSuccess = this.getRequestSuccess();
        result = result * 59 + ($requestSuccess == null ? 43 : $requestSuccess.hashCode());
        Object $responseSuccess = this.getResponseSuccess();
        result = result * 59 + ($responseSuccess == null ? 43 : $responseSuccess.hashCode());
        Object $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        Object $apiUrl = this.getApiUrl();
        result = result * 59 + ($apiUrl == null ? 43 : $apiUrl.hashCode());
        Object $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Object $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        Object $headerParam = this.getHeaderParam();
        result = result * 59 + ($headerParam == null ? 43 : $headerParam.hashCode());
        Object $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : $queryParam.hashCode());
        Object $bodyParam = this.getBodyParam();
        result = result * 59 + ($bodyParam == null ? 43 : $bodyParam.hashCode());
        Object $addressIp = this.getAddressIp();
        result = result * 59 + ($addressIp == null ? 43 : $addressIp.hashCode());
        Object $requestTime = this.getRequestTime();
        result = result * 59 + ($requestTime == null ? 43 : $requestTime.hashCode());
        Object $responseTime = this.getResponseTime();
        result = result * 59 + ($responseTime == null ? 43 : $responseTime.hashCode());
        Object $requestFailMessage = this.getRequestFailMessage();
        result = result * 59 + ($requestFailMessage == null ? 43 : $requestFailMessage.hashCode());
        Object $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        Object $responseFailMessage = this.getResponseFailMessage();
        result = result * 59 + ($responseFailMessage == null ? 43 : $responseFailMessage.hashCode());
        Object $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Object $targetApp = this.getTargetApp();
        result = result * 59 + ($targetApp == null ? 43 : $targetApp.hashCode());
        Object $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        Object $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        Object $businessTypeName = this.getBusinessTypeName();
        result = result * 59 + ($businessTypeName == null ? 43 : $businessTypeName.hashCode());
        Object $businessKey = this.getBusinessKey();
        result = result * 59 + ($businessKey == null ? 43 : $businessKey.hashCode());
        return result;
    }

    public String toString() {
        String var10000 = this.getServerUrl();
        return "InfinityLogVO(serverUrl=" + var10000 + ", apiUrl=" + this.getApiUrl() + ", uri=" + this.getUri() + "," +
                " requestMethod=" + this.getRequestMethod() + ", headerParam=" + this.getHeaderParam() + ", " +
                "queryParam=" + this.getQueryParam() + ", bodyParam=" + this.getBodyParam() + ", addressIp=" + this.getAddressIp() + ", requestTime=" + this.getRequestTime() + ", responseTime=" + this.getResponseTime() + ", spendTime=" + this.getSpendTime() + ", requestSuccess=" + this.getRequestSuccess() + ", requestFailMessage=" + this.getRequestFailMessage() + ", responseBody=" + this.getResponseBody() + ", responseSuccess=" + this.getResponseSuccess() + ", responseFailMessage=" + this.getResponseFailMessage() + ", traceId=" + this.getTraceId() + ", targetApp=" + this.getTargetApp() + ", tenantCode=" + this.getTenantCode() + ", businessType=" + this.getBusinessType() + ", businessTypeName=" + this.getBusinessTypeName() + ", businessKey=" + this.getBusinessKey() + ")";
    }
}
