package com.elitescloud.cloudt.system.model.vo.resp.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 三方接口详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/15
 */
@Data
@ApiModel(description = "三方接口分页信息")
public class ThirdApiLogPageRespVO implements Serializable {
    private static final long serialVersionUID = 4278330152038430319L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 2)
    private String appCode;

    /**
     * 源系统
     */
    @ApiModelProperty(value = "源系统", position = 3)
    private String sourceSystem;

    /**
     * 是否内部调用
     */
    @ApiModelProperty(value = "目标系统", position = 4)
    private String targetSystem;

    /**
     * 服务端地址
     */
    @ApiModelProperty(value = "服务端地址", position = 5)
    private String serverAddr;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型", position = 6)
    private String businessType;

    /**
     * 业务数据标识
     */
    @ApiModelProperty(value = "业务数据标识", position = 7)
    private String businessKey;

    /**
     * 请求用户
     */
    @ApiModelProperty(value = "请求用户", position = 8)
    private String username;

    /**
     * 请求的接口地址
     */
    @ApiModelProperty(value = "请求的接口地址", position = 9)
    private String uri;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式", position = 10)
    private HttpMethod reqMethod;

    /**
     * 请求时间
     */
    @ApiModelProperty(value = "请求时间", position = 11)
    private LocalDateTime reqTime;

    /**
     * 请求时间
     */
    @ApiModelProperty(value = "请求时间", position = 12)
    private LocalDateTime respTime;

    /**
     * 重试次数
     */
    @ApiModelProperty(value = "重试次数", position = 13)
    private Integer retryTimes;

    /**
     * 响应状态
     */
    @ApiModelProperty(value = "响应状态", position = 14)
    private Boolean respSuccess;

    /**
     * 错误信息
     */
    @ApiModelProperty(value = "错误信息", position = 15)
    private String failReason;

    /**
     * 是否是重试记录
     */
    @ApiModelProperty(value = "是否是重试记录", position = 16)
    private Boolean retried;

    /**
     * 是否是手动重试
     */
    @ApiModelProperty(value = "是否是手动重试", position = 17)
    private Boolean manualRetry;
}
