package com.elitescloud.cloudt.system.model.vo.resp.message;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * @author Chris
 * @date 2021-08-22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MsgPayload {

    /**
     * 消息实体ID
     */
    private Long carrierId;

    /**
     * 发件人
     */
    private String from;

    /**
     * 收件人
     */
    private String[] tos;

    /**
     * 主题
     */
    private String subject;

    /**
     * 标题
     */
    private String title;

    /**
     * 解析好的内容
     */
    private String content;

    /**
     * 发送方式
     * {@link com.elitescloud.coord.messenger.sender.provider.TransTypeEnum}
     */
    private String transType;

    /**
     * 发送配置编号
     */
    private String transCode;

    /**
     * 是否富文本，只针对邮件有效
     */
    private boolean isRichContent;

    /**
     * 扩展信息，针对具体不同的sender可能有不同的配置
     */
    private Map<String, Object> extend;
}
